using System;
using System.IO;
using System.Text;
using System.Data;
using System.Drawing;
using System.Security;
using System.Reflection;
using System.Diagnostics;
using System.Collections;
using System.Windows.Forms;
using System.ComponentModel;
using System.Security.Policy;
using System.Security.Permissions;

namespace Step_04
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private static StringBuilder debug = new StringBuilder();

		private TheControl.RegLister theControl;
		private System.Windows.Forms.TextBox txLog;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.theControl = new TheControl.RegLister();
			this.txLog = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// theControl
			// 
			this.theControl.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.theControl.BackColor = System.Drawing.Color.LightSteelBlue;
			this.theControl.Location = new System.Drawing.Point(0, 0);
			this.theControl.Name = "theControl";
			this.theControl.Size = new System.Drawing.Size(680, 184);
			this.theControl.TabIndex = 0;
			// 
			// txLog
			// 
			this.txLog.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txLog.Location = new System.Drawing.Point(0, 176);
			this.txLog.Multiline = true;
			this.txLog.Name = "txLog";
			this.txLog.ReadOnly = true;
			this.txLog.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.txLog.Size = new System.Drawing.Size(680, 216);
			this.txLog.TabIndex = 1;
			this.txLog.Text = "";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(680, 398);
			this.Controls.Add(this.txLog);
			this.Controls.Add(this.theControl);
			this.Name = "Form1";
			this.Text = "Form1";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			AppDomain.CurrentDomain.AssemblyLoad += new AssemblyLoadEventHandler(ReportAssembly);

			Zone pInternet = new Zone(SecurityZone.Internet);
			object[] aInternet = new object[] { pInternet };
	
			Evidence pEvInternet = new Evidence(aInternet, null);

			Assembly.LoadFrom("RegHelp.dll", pEvInternet);
			Assembly.LoadFrom("TheControl.dll", pEvInternet);

			for ( IEnumerator e = SecurityManager.PolicyHierarchy() ; e.MoveNext() ; )
			{
				PolicyLevel pPol = (PolicyLevel)e.Current;

				if ( pPol.Label.Equals("Machine") )
				{
					pPol.GetNamedPermissionSet("Internet").PermitOnly();

					break;
				}
			}

			Application.Run(new Form1());
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
			Text = Assembly.GetExecutingAssembly().FullName;
			
			txLog.Text = debug.ToString();
		}

		private static void DebugWriteLine(object sLine)
		{
			debug.Append(sLine.ToString() + Environment.NewLine);			
		}

		[
			SecurityPermission(SecurityAction.Assert, Flags = SecurityPermissionFlag.ControlEvidence)
		]
		private static void ReportAssembly(object sender, AssemblyLoadEventArgs args)
		{
			Assembly pNew = args.LoadedAssembly;

			if ( !pNew.FullName.StartsWith("TheControl") && !pNew.FullName.StartsWith("RegHelp") ) return;

			DebugWriteLine(string.Empty);
			DebugWriteLine(new string('-', 80));
			DebugWriteLine(pNew.FullName);

			try
			{
				foreach ( object pEv in pNew.Evidence )
					if ( pEv.GetType() != typeof(Hash) )
						DebugWriteLine(pEv);

				for ( IEnumerator e = SecurityManager.ResolvePolicyGroups(pNew.Evidence) ; e.MoveNext() ; )
					DebugWriteLine(((CodeGroup)e.Current).ToXml());

				DebugWriteLine(SecurityManager.ResolvePolicy(pNew.Evidence).ToXml());
			}
			catch (Exception e)
			{
				DebugWriteLine(e.ToString());
			}
		}
	}
}
